"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.Module = void 0;
const path = require('path');
const bindings = require('bindings');
exports.Module = bindings({
    bindings: 'saleae_graph_interface.node',
    module_root: path.dirname(__dirname),
    try: [
        ['module_root', 'build', 'Release', 'bindings'],
        ['module_root', 'build', 'Debug', 'bindings'],
        ['module_root', 'bin', `${process.platform}-${process.arch}-${process.versions.modules}`, 'graph-interface.node'],
        ['module_root', 'bin', `${process.platform}-${process.arch}-89`, 'graph-interface.node'],
    ],
});
class Instance extends exports.Module.Instance {
    constructor() {
        super(...arguments);
        this._notifyMessageCallbacks = [];
        this._logCallback = (message) => { };
    }
    send(message) {
        return this._send(JSON.stringify(message));
    }
    recv() {
        while (true) {
            const result = this._tryRecv();
            if (result === null) {
                return new Promise(resolve => {
                    this._notifyMessageCallbacks.push(() => resolve(undefined));
                });
            }
            else {
                return JSON.parse(result);
            }
        }
    }
    recvNoWait() {
        const result = this._tryRecv();
        if (result !== null) {
            return JSON.parse(result);
        }
    }
    _onNotifyMessage() {
        const callbacks = this._notifyMessageCallbacks;
        this._notifyMessageCallbacks = [];
        for (const callback of callbacks) {
            callback();
        }
    }
}
exports.Instance = Instance;
//# sourceMappingURL=instance.js.map